# playersdk-ios点播多实例文档
在多实例场景下，请使用GSVodObject类创建对象。单利模式依旧使用GSVodManager类进行管理没有改变。
**SDK默认最多同时创建10个点播播放器对象。超过10个时请调用播放器销毁方法。**
**如需要修改默认值，请在创建播放器之前设置self.vodObj.cacheNum_Max的值，建议不要超过10个。**
**SDK不支持同时创建多个点播信息相同的对象**
# 创建点播播放器流程
创建多个点播之前需要设置音频会话，设置一次就行了。
```
    [GSVodObject vodSetDefaultAudioSessionCategory];
```
GSVodObject提供的方法默认设置的是
AVAudioSessionCategory = AVAudioSessionCategoryPlayback；
AVAudioSessionCategoryOptions = （AVAudioSessionCategoryOptionMixWithOthers|AVAudioSessionCategoryOptionAllowBluetooth|AVAudioSessionCategoryOptionDefaultToSpeaker）；
AVAudioSessionMode = AVAudioSessionModeDefault ；

（1）创建GSVodObject类对象
```
   self.vodObj = [[GSVodObject alloc]init];
```
  
（2）获取点播数据
> self.params是GSConnectInfo类对象，用法与之前相同。
```
   [self.vodObj request:self.params completion:^(downItem *item, GSVodWebaccessError type) {
            if(type == GSVodWebaccessSuccess){
              // 获取点播数据成功
                self.item = item;
            }
        }];
```

（3）创建点播播放器
> 使用vodObj对象创建的播放器默认是暂停播放的， 如果需要播放请调用[vodObj.player resume]方法。
```
    [self.vodObj createVodPlayerWithDownItem:self.item VodPlayDelegate:self];
```

（4）销毁点播播放器
> SDK最多支持同时创建10个点播播放器对象。超过10个时请调用播放器销毁方法。
```
    [self.vodObj destroyVodPlayer];
```
# 视频渲染
视频渲染使用的依旧是VodGLView类，用法与之前一致。
（1）创建vodView对象
```
       VodGLView * vodView = [[VodGLView alloc] initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, TableViewHeight) renderMode:renderMode];
       vodView.contentMode = videoMode;
       vodView.backgroundColor = [UIColor blackColor];
       vodView.translatesAutoresizingMaskIntoConstraints = NO;
       [self.contentView addSubview:vodView];
       self.vodView = vodView;
```

（2）关联点播播放器
> VodPlayDelegate代理回调方法与之前一致。
```
    self.vodObj.player.delegate = (id<VodPlayDelegate>)self;
    self.vodObj.player.mVideoView = self.vodView;
```

（3）新增渲染最后一帧方法
> 调用此方法后，会将最后一帧数据渲染到vodView上。
```
    [self.vodObj.player renderPlayerLastVideoData];
```

（4）新增渲染第一帧方法
> 调用此方法后，会将最后一帧数据渲染到vodView上。
```
    [self.vodObj.player renderPlayerFirstVideoData];
```

# 播放器控制
播放器控制：暂停、恢复、倍速、快进等方法与之前一致。
```
     [self.vodObj.player pause];
     [self.vodObj.player seekTo:0];
     [self.vodObj.player resume];
     [self.vodObj.player SpeedPlay:SPEED_NORMAL];
```
GSVodPlayerBar类也与之前一致。

# 播放结束
> 点播播放结束后会收到<VodPlayDelegate>代理回调方法
```
- (void)onStop;
```

> 如果想要在播放结束后继续播放，需要先调用self.vodObj.player的
```
- (void)OnlinePlay:(BOOL)postChat audioOnly:(BOOL)audioOnly;
```
方法重置播放器（注意：调用此方法后，播放器会回到初始状态），再调用self.vodObj.player的
```
- (void)resume;
```
 方法继续播放。

> 代码示例：
```
- (void)onStop{
  [self.vodObj.player OnlinePlay:NO audioOnly:NO];
  [self.vodObj.player resume];
  }
```

# 获取点播在线观看的缓存文件夹路径
> 在线观看点播时，会将点播信息缓存到本地online文件夹中。在使用多实例时，如果有需要删除本地缓存的点播文件，可以调用该方法获取文件所在路径。

```
[GSVodObject getVodOnlineFilesPath];
```
